import chokidar from 'chokidar';
import fs from 'fs'
import fse from 'fs-extra';
import jade from 'jade';
import klaw from 'klaw';
import beautify from 'beautify';
import cleaner from 'clean-html';
import fg from 'fast-glob';
import inliner from '@css-inline/css-inline';

// ====================================================================
// |  
// ====================================================================
function log(message) {
  const options = { 
    encoding: "utf-8", 
    flag: "a+", 
  };
  const datetime = new Date().toISOString()
  message = `[${datetime}] ${message}\n`
  fse.outputFileSync('/logs/builder/jade.log', message, options);
  console.log(message)
}

// ====================================================================
// |    
// ====================================================================
function compile(path) {

  log(`${path} was changed`)

  // Do not compile inside .delete folders
  if (path.includes(".delete")) {
    return
  }

  // Do not compile inside _partials folders
  if (path.includes("layouts")) {
    log("Recompiling /app/views/layouts")
    compileAll('/app/views/layouts/**/*.jade')
    return
  }

  // Do not compile inside _partials folders
  if (path.includes("_partials") || path.includes("partials")) {
    log("Recompiling /app/views")
    compileAll('/app/views/**/*.jade')
    return
  }

 // Do not compile partials (begins with _)
  const filename = path.split("/").slice(-1).toString()
  if (filename.startsWith("_")) {
    const underscorecount = (filename.match(/_/g) || []).length;
    const directoryIndex = 0 - underscorecount
    const parentDirectory = path.split("/").slice(0,directoryIndex).join("/")+'/**/*.jade'
    log("Recompiling "+parentDirectory)
    compileAll( parentDirectory )
    return
  }

  // Do not compile if the file does not end with .jade
  if (!path.endsWith(".jade")) {
    return
  }    

  log(`  Recompiling ${path}`)
  const options = {
    basedir: '/app/views'
  }
  var result = '';
  result = jade.renderFile(path,options);

  var publicPath = path
  publicPath = publicPath.replace('/app/views','/www')
  publicPath = publicPath.replace('.jade','.html')

  // Convert to CSS Inline for Email Templates
  // if (publicPath.includes("/www/emails")) {
  //   console.log('Inlining Email Template CSS')
  //   result = inliner.inline(result);
  //   console.log('Inlining Email Template CSS Done');
  // }

  //-  
  //-  Clean HTML Section.  Could cause more harm then good. Disabled for now 
  //-   
  // try {
  //   cleaner.clean(result, output => {
  //     fse.outputFileSync(publicPath, output);
  //   });
  // } catch (err) {
  //     try {
  //       var pretty_options = {format: 'html'}
  //       fse.outputFileSync(publicPath, beautify(result, pretty_options));
  //     } catch (err) {
  //       fse.outputFileSync(publicPath, result);
  //       log(`[ERROR] HTML Cleaner: ${path}`)
  //       log(err)
  //       log(`[ERROR] Unformatted jade file was saved`)
  //     }
  // }
  fse.outputFileSync(publicPath, result);
}

// ====================================================================
// |    
// ====================================================================
function compileParents(path) {

  // Do not compile inside .delete folders
  if (path.includes(".delete")) {
    return
  }

  // Do not compile partials (begins with _)
  const filename = path.split("/").slice(-1).toString()
  if (filename.startsWith("_")) {
    return
  }

  // Do not compile inside _partials folders
  if (path.includes("_partials") || path.includes("partials")) {
    return
  }

  // Do not compile if the file does not end with .jade
  if (!path.endsWith(".jade")) {
    return
  }    

  // log(`  Recompiling ${path}`)
  const options = {
    basedir: '/app/views'
  }  
  var result = '';
  result = jade.renderFile(path, options);

  var publicPath = path
  publicPath = publicPath.replace('/app/views','/www')
  publicPath = publicPath.replace('.jade','.html')
  
  // Convert to CSS Inline for Email Templates
  // if (publicPath.includes("/www/emails")) {
  //   console.log('Inlining Email Template CSS')
  //   result = inliner.inline(result);
  //   console.log('Inlining Email Template CSS Done');
  // }

  //-  
  //-  Clean HTML Section.  Could cause more harm then good. Disabled for now 
  //-   
  // try {
  //   cleaner.clean(result, output => {
  //     fse.outputFileSync(publicPath, output);
  //   });
  // } catch (err) {
  //     try {
  //       var pretty_options = {format: 'html'}
  //       fse.outputFileSync(publicPath, beautify(result, pretty_options));
  //     } catch (err) {
  //       fse.outputFileSync(publicPath, result);
  //       log(`[ERROR] HTML Cleaner: ${path}`)
  //       log(err)
  //       log(`[ERROR] Unformatted jade file was saved`)
  //     }
  // }
  fse.outputFileSync(publicPath, result);

}

// ====================================================================
// |    
// ====================================================================
function compileAll(glob) {
  return new Promise((resolve, reject) => {
    const jadeFiles = fg.globSync(glob)
    for (const file of jadeFiles) {
      compileParents(file);
    }
  });
}

// ====================================================================
// |    
// ====================================================================
function startWatcher() {
  const watchFolders = [
    '/app/views/**/*.jade',
  ]

  // https://github.com/paulmillr/chokidar
  const options = {
    awaitFinish: true,
    ignoreInitial: true,
    usePolling: true,
    interval: 100    
  }

  const watcher = chokidar.watch(watchFolders, options).on('all', (event, path) => {
  });

  watcher
    .on('add', path => compile(path))
    .on('change', path => compile(path))
    .on('unlink', path => compile(path));

  watcher
    .on('ready', () => log('**********    Watch is running    **********'));
}

// ====================================================================
// |    MAIN
// ====================================================================
async function go() {
  if (process.argv[2] == 'compile-and-watch') {
    await compileAll('/app/views/**/*.jade');
    startWatcher();
  } else if(process.argv[2] == 'compile-only') {
    await compileAll('/app/views/**/*.jade');
  } else {
    startWatcher();
  }
}

go()