import chokidar from 'chokidar';
import fs from 'fs'
import fse from 'fs-extra';
import pug from 'pug';
import klaw from 'klaw';
import pretty from 'pretty';

// ====================================================================
// |  
// ====================================================================
function log(message) {
  const options = { 
    encoding: "utf-8", 
    flag: "a+", 
  };
  const datetime = new Date().toISOString()
  message = `[${datetime}] ${message}\n`
  fse.outputFileSync('/logs/builder/pug.log', message, options);
  console.log(message)
}

// ====================================================================
// |  
// ====================================================================
function printChange(path) {
  log(path) 
}

// ====================================================================
// |    
// ====================================================================
function compile(path) {

  // Do not compile inside .delete folders
  if (path.includes(".delete")) {
    return
  }

  // Do not compile partials (begins with _)
  const filename = path.split("/").slice(-1).toString()
  if (filename.startsWith("_")) {
    compileAll()
    return
  }

  // Do not compile inside _partials folders
  if (path.includes("_partials") || path.includes("partials")) {
    log('Partial Edited.  Recompile all!')
    compileAll()
    return
  }

  // Do not compile if the file does not end with .pug
  if (!path.endsWith(".pug")) {
    log('Partial Edited.  Recompile all!')
    return
  }    

  log(`Recompiling ${path}`)
  const result = pug.renderFile(path);

  var publicPath = path
  publicPath = publicPath.replace('/app/views','/www')
  publicPath = publicPath.replace('.pug','.html')

  fse.outputFile(publicPath, pretty(result), err => {
    if (err) {
      console.error(err);
    }
    // file written successfully
  });

}

// ====================================================================
// |    
// ====================================================================
function compileParents(path) {

  // Do not compile inside .delete folders
  if (path.includes(".delete")) {
    return
  }

  // Do not compile partials (begins with _)
  const filename = path.split("/").slice(-1).toString()
  if (filename.startsWith("_")) {
    return
  }

  // Do not compile inside _partials folders
  if (path.includes("_partials") || path.includes("partials")) {
    return
  }

  // Do not compile if the file does not end with .pug
  if (!path.endsWith(".pug")) {
    return
  }    

  log(`Recompiling ${path}`)
  const result = pug.renderFile(path);

  var publicPath = path
  publicPath = publicPath.replace('/app/views','/www')
  publicPath = publicPath.replace('.pug','.html')

  fse.outputFile(publicPath, pretty(result), err => {
    if (err) {
      console.error(err);
    }
    // file written successfully
  });

}


// ====================================================================
// |    
// ====================================================================
function compileAll() {
  klaw('/app/views')
    .on('data', item => compileParents(item.path))
}

// ====================================================================
// |    
// ====================================================================
const watchFolders = [
  '/app/views/**/*.pug',
]

var ignoreInitial = true
if (process.argv[2] == 'recompile') {
  ignoreInitial = false
}

// https://github.com/paulmillr/chokidar
const options = {
    awaitFinish: true,
    ignoreInitial: true,
    usePolling: true,
    interval: 100
}

const watcher = chokidar.watch(watchFolders, options).on('all', (event, path) => {
  // log(event, path);
});

watcher
  .on('add', path => compile(path))
  .on('change', path => compile(path))
  .on('unlink', path => compile(path));