import chokidar from 'chokidar';
import fs from 'fs'
import fse from 'fs-extra';
import path from 'path';
import fg from 'fast-glob';

// ====================================================================
// |  
// ====================================================================
function log(message) {
  const options = { 
    encoding: "utf-8", 
    flag: "a+", 
  };
  const datetime = new Date().toISOString()
  message = `[${datetime}] ${message}\n`
  fse.outputFileSync('/logs/builder/javascript.log', message, options);
  console.log(message)
}

// ====================================================================
// |    
// ====================================================================
function concatJavascript(path) {
  log('-----------------------'); 
  log(path);

  var publicPath = path
  publicPath = publicPath.replace('/app/js','/www/js')

  var jsFolder = path;
  jsFolder = jsFolder.split("/")[3];

  const source = `/app/js/${jsFolder}`
  const destination = `/www/js/${jsFolder}.js`
  fs.readdir(source, (err, files) => {
    if (err) throw err;

    fse.ensureFileSync(destination)
    fs.writeFileSync(destination,'')
    var sortedfiles = files.sort()
    sortedfiles.forEach(file => {
      const filePath = `${source}/${file}`
      var contents = fs.readFileSync(filePath);
      const spacer = `\n// ====================================================================\n// |\n// |\n// |  ${file}\n// |\n// |\n// ====================================================================\n`
      fs.appendFileSync(destination, spacer+contents)
    });
  });

}

// ====================================================================
// |    
// ====================================================================
function compileAll(glob) {
  return new Promise((resolve, reject) => {
    const javascriptFiles = fg.globSync(glob)
    for (const file of javascriptFiles) {
      concatJavascript(file);
    }
    log(`Done`)
  });
}

// ====================================================================
// |    
// ====================================================================
function startWatcher(watchFolders) {

  // https://github.com/paulmillr/chokidar
  const options = {
    awaitFinish: true,
    ignoreInitial: true,
    usePolling: true,
    interval: 100    
  }

  const watcher = chokidar.watch(watchFolders, options).on('all', (event, path) => {
    log(event, path);
  });

  watcher
    .on('add', path => concatJavascript(path))
    .on('change', path => concatJavascript(path))
    .on('unlink', path => concatJavascript(path));

  watcher
    .on('ready', () => log('**********    Watch is running    **********'));

}

// ====================================================================
// |    MAIN
// ====================================================================
async function go() {
  const watchFolders = [
    '/app/js'
  ] 
  if (process.argv[2] == 'recompile') {
    await compileAll('/app/js/*/**.js')
    startWatcher(watchFolders);
  } else {
    startWatcher(watchFolders);
  }
}

go()  