#!/bin/bash
CANARY_FILE=/app/.provisioning/builder-rebuild

if [ ! -f "$CANARY_FILE" ] ; then
  echo "Initialization incomplete!  Running Builder Rebulid..."
  cd /opt/builder/app && bash ./clean-and-build.sh &
  mkdir -p /app/.provisioning && date +%F_%T >> /app/.provisioning/builder-rebuild 
else

  ln -sf /app/docs /www
  ln -sf /app/fonts /www
  ln -sf /app/images /www
  ln -sf /app/libs /www
  ln -sf /app/lib /www

  pm2 delete all
  pm2 start /opt/builder/app/sass-watcher.js
  pm2 start /opt/builder/app/javascript-watcher.js
  pm2 start /opt/builder/app/jade-watcher.js
  # pm2 start /opt/builder/app/pug-watcher.js
  # pm2 start /opt/builder/app/assets-watcher.js

fi